/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   Boot Flash File System API Header File
::   Copyright   :   (C)2004-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   None
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \file Resource_BootFFS.h
    \brief The Flash File System (FFS) within the boot block allows executable images and data to be stored
           within the NANDFlash in a manner that will allow it to be accessed by the boot code as well as the
           application
*/
    
#ifndef __RESOURCE_BOOTFFS_H
#define __RESOURCE_BOOTFFS_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/
#include <typedefn.h>
#include <resource.h>

/*----- DEFINES -------------------------------------------------------------------------------------------*/

/*----- TYPEDEFS ------------------------------------------------------------------------------------------*/
#pragma pack(1)


#pragma pack()
/*----- EXTERNALS -----------------------------------------------------------------------------------------*/

/*----- PROTOTYPES ----------------------------------------------------------------------------------------*/
NativeError_S WriteImageBootFFS(uint1 const* in_pImage, sint4 nImageByteSize, NativeVar_U ImageId, void* pStartAddr);
NativeError_S ReadImageBootFFS(uint4 nImageId,
                               uint4 nByteOffset,
                               uint1* out_pData,
                               uint4 uBytesToRead,
                               uint4* out_BytesRead);
NativeError_S ExecuteImageBootFFS(uint4 nImageId);
NativeError_S VerifyImageBootFFS(uint1 const* in_pImage, sint4 nImageByteSize, uint4 nImageId);
NativeError_S EraseImageBootFFS(uint4 nImageId);

#endif /* __RESOURCE_BOOTFFS_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/
